﻿#####################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
#####################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
##############################################
# Description:
# vSphere CMDB script 1 of 5. This script sets the SQL & vSphere credentials for use in the other 4 scripts.
##############################################
# Requirements:
# - Set-executionpolicy unrestricted on the computer running the script
# - Run the script as administrator to allow the install of the new module for all users
# - Internet access in order to download the SqlServer and PowerCLI modules if not already installed
##############################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever. 
# Including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss arising out of the use of,
# or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
############################################################################################
# Nothing to change below this line, comments provided if you need/want to change anything
############################################################################################
# Prompts and saves SQL creds
Get-Credential -Message "Enter your SQL username & password" | EXPORT-CLIXML ".\SQLCredentials.xml"
# Prompts and saves vCenter creds
Get-Credential -Message "Enter your vCenter username & password" | EXPORT-CLIXML ".\vCenterCredentials.xml"
##############################################
# Checking if the SqlServer module is already installed, if not installing it
##############################################
$SQLModuleCheck = Get-Module -ListAvailable SqlServer
if ($SQLModuleCheck -eq $null)
{
write-host "SqlServer Module Not Found - Installing"
# Not installed, trusting PS Gallery to remove prompt on install
Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
# Installing module
Install-Module -Name SqlServer –Scope AllUsers -Confirm:$false -AllowClobber
}
$PowerCLIModuleCheck = Get-Module -ListAvailable VMware.PowerCLI
##############################################
# Checking if the SqlServer module is already installed, if not installing it
##############################################
if ($PowerCLIModuleCheck -eq $null)
{
write-host "PowerCLI Module Not Found - Installing"
# Trusting PS Gallery to remove prompt on install
Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
# Installing module
Install-Module -Name VMware.PowerCLI –Scope AllUsers -Confirm:$false
}
#######################
# End of script
#######################