﻿#####################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
#####################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
##############################################
# Description:
# vSphere CMDB script 5 of 5. This script prunes any records older than the configured $SQLDataMaxHistoryInDays on line 31. Use as often, or not, as wanted.
##############################################
# Requirements:
# - Set-executionpolicy unrestricted on the computer running the script
# - Access to a SQL server instance and vCMDB with sufficient permissions to delete rows from the database created
##############################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever. 
# Including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss arising out of the use of,
# or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
##############################################
# Configure the variables below for connecting to the SQL database
##############################################
# SQL server, database & authentication
$SQLInstance = ".\SQLEXPRESS"
$SQLDatabase = "vSphereCMDB"
# Max record retention history, after x configured days (any max, or just don't run this script), records are deleted from the database
$SQLDataMaxHistoryInDays = "365" 
############################################################################################
# Nothing to change below this line, comments provided if you need/want to change anything
############################################################################################
##############################################
# Importing the SQL credentials
##############################################
$SQLCredentials = IMPORT-CLIXML ".\SQLCredentials.xml"
$SQLUsername = $SQLCredentials.UserName
$SQLPassword = $SQLCredentials.GetNetworkCredential().Password
##############################################
# Checking to see if the SqlServer module is already installed, if not installing it
##############################################
$SQLModuleCheck = Get-Module -ListAvailable SqlServer
if ($SQLModuleCheck -eq $null)
{
write-host "SqlServer Module Not Found - Installing"
# Not installed, trusting PS Gallery to remove prompt on install
Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
# Installing module
Install-Module -Name SqlServer –Scope AllUsers -Confirm:$false -AllowClobber
}
##############################################
# Importing the SqlServer module
##############################################
Import-Module SqlServer
##############################################
# Setting the current dates (for use in each SQL row inserted to prune history)
##############################################
$LastUpdated = "{0:yyyy-MM-dd HH:mm:ss}" -f (Get-Date)
# Subtracting the SQLDataMaxHistoryInDays from the current time to prune data older than this date
$MaxHistoryDate = "{0:yyyy-MM-dd HH:mm:ss}" -f (Get-Date).AddDays(-$SQLDataMaxHistoryInDays)
##############################################
# Pruning VMs SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLVMPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM VMs"
# Run the SELECT query
$VMPruneOutput = $null
$VMPruneOutput = invoke-sqlcmd -query $SQLVMPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$VMRecordsToPrune = $VMPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($VMRecordsToPrune -ne $null)
{
ForEach($VMRecord in $VMRecordsToPrune)
{
$VMRecordID = $VMRecord.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteVMRecord = "USE $SQLDatabase
DELETE FROM VMs
WHERE RecordID='$VMRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteVMRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning VMDisks SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLVMDiskPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM VMDisks"
# Run the SELECT query
$VMDiskPruneOutput = $null
$VMDiskPruneOutput = invoke-sqlcmd -query $SQLVMDiskPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$VMDiskRecordsToPrune = $VMDiskPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($VMDiskRecordsToPrune -ne $null)
{
ForEach($VMDisk in $VMDiskRecordsToPrune)
{
$VMDiskRecordID = $VMDisk.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteVMDiskRecord = "USE $SQLDatabase
DELETE FROM VMDisks
WHERE RecordID='$VMDiskRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteVMDiskRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning VMNICs SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLVMNICsPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM VMNICs"
# Run the SELECT query
$VMNICPruneOutput = $null
$VMNICPruneOutput = invoke-sqlcmd -query $SQLVMNICsPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$VMNICRecordsToPrune = $VMNICPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($VMNICRecordsToPrune -ne $null)
{
ForEach($VMNIC in $VMNICRecordsToPrune)
{
$VMNICRecordID = $VMNIC.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteVMNICRecord = "USE $SQLDatabase
DELETE FROM VMNICs
WHERE RecordID='$VMNICRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteVMNICRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning Datastores SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLDatastoresPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM Datastores"
# Run the SELECT query
$DatastorePruneOutput = $null
$DatastorePruneOutput = invoke-sqlcmd -query $SQLDatastoresPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$DatastoreRecordsToPrune = $DatastorePruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($DatastoreRecordsToPrune -ne $null)
{
ForEach($Datastore in $DatastoreRecordsToPrune)
{
$DatstoreRecordID = $Datastore.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteDatstoreRecord = "USE $SQLDatabase
DELETE FROM Datastores
WHERE RecordID='$DatstoreRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteDatstoreRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning PortGroups SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLPortGroupsPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM PortGroups"
# Run the SELECT query
$PortGroupPruneOutput = $null
$PortGroupPruneOutput = invoke-sqlcmd -query $SQLPortGroupsPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$PortGroupRecordsToPrune = $PortGroupPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($PortGroupRecordsToPrune -ne $null)
{
ForEach($PortGroup in $PortGroupRecordsToPrune)
{
$PortGroupRecordID = $PortGroup.RecordID
# Creating the DELETE query using the variables defined
$SQLDeletePortGroupRecord = "USE $SQLDatabase
DELETE FROM PortGroups
WHERE RecordID='$PortGroupRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeletePortGroupRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning Hosts SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLHostsPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM Hosts"
# Run the SELECT query
$HostPruneOutput = $null
$HostPruneOutput = invoke-sqlcmd -query $SQLHostsPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$HostRecordsToPrune = $HostPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($HostRecordsToPrune -ne $null)
{
ForEach($ESXiHost in $HostRecordsToPrune)
{
$HostRecordID = $ESXiHost.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteHostRecord = "USE $SQLDatabase
DELETE FROM Hosts
WHERE RecordID='$HostRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteHostRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning Clusters SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLClustersPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM Clusters"
# Run the SELECT query
$ClusterPruneOutput = $null
$ClusterPruneOutput = invoke-sqlcmd -query $SQLClustersPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$ClusterRecordsToPrune = $ClusterPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($ClusterRecordsToPrune -ne $null)
{
ForEach($Cluster in $ClusterRecordsToPrune)
{
$ClusterRecordID = $Cluster.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteClusterRecord = "USE $SQLDatabase
DELETE FROM Clusters
WHERE RecordID='$ClusterRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteClusterRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
##############################################
# Pruning Datacenters SQL Table
##############################################
# Creating the SELECT query to find records to prune 
$SQLDatacentersPruneQuery = "USE $SQLDatabase
SELECT RecordID, LastUpdated FROM Datacenters"
# Run the SELECT query
$CDatacenterPruneOutput = $null
$DatacenterPruneOutput = invoke-sqlcmd -query $SQLDatacentersPruneQuery -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Selecting records to delete based on those older than the MaxHistoryDate
$DatacenterRecordsToPrune = $DatacenterPruneOutput | Where-Object { $_.LastUpdated -lt $MaxHistoryDate}
# Performing DELETE for each applicable record, if value is not NULL (matching records were found outside of the max history range)
If ($DatacenterRecordsToPrune -ne $null)
{
ForEach($Datacenter in $CDatacenterRecordsToPrune)
{
$DatacenterRecordID = $Datacenter.RecordID
# Creating the DELETE query using the variables defined
$SQLDeleteDatacenterRecord = "USE $SQLDatabase
DELETE FROM Datacenters
WHERE RecordID='$DatacenterRecordID';"
# Running the DELETE query
invoke-sqlcmd -query $SQLDeleteDatacenterRecord -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
}
#######################
# End of script
#######################