########################################################################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
################################################
# Description:
# This script allows you to securely store your credentials for RUbrik and an SMTP server, the resulting .xml files are used by all the other scripts
################################################ 
# Requirements:
# - Run PowerShell as administrator with command "Set-ExecutionPolcity unrestricted" on the host running the script
################################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever (including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss) arising out of the use of or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
################################
# Nothing to configure below, just run the script to securely store your credentials
################################
# Specify your Rubrik user name & password
$RubrikCredentials = Get-Credential -Message "Enter Rubrik login credentials"
$RubrikCredentials | EXPORT-CLIXML "C:\RubrikAutoTicketingv1\RubrikCredentials.xml"
# Specify your username and password required to authenticate with SMTP
$SMTPCredentials = Get-Credential -Message "Enter SMTP Authentication credentials"
$SMTPCredentials | EXPORT-CLIXML "C:\RubrikAutoTicketingv1\SMTPCredentials.xml"
################################
# End of script
################################