﻿#####################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
#####################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
##############################################
# Description:
# This script checks to see if an old version of PowerCLI is installed in Program Files. If it is, the script uninstalls it.
# It then checks to see if the PowerCLI module exists, if not, it is installed and saved in a directory for offline access.
# Tested on upgrading from PowerCLI VMware-PowerCLI-6.0.0-2548067
##############################################
# Requirements:
# - Internet access on the computer running this script to download the latest module
# - Run the script as administrator to enable the uninstall of the existing module and to allow the install of the new module for all users
##############################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever. 
# Including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss arising out of the use of,
# or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
#######################
# Configure the variable below
#######################
# Specify a directory to download and install the new PowerCLI module to for future offline access
$PSModulePath = "c:\PowerCLIModule\"
#####################################################################
# Nothing to change below this line, commented throughout to explain
#####################################################################
#######################
# Testing if PS Module path exists, if not creating it
#######################
$PSModulePathTest = test-path $PSModulePath
if ($PSModulePathTest -eq $False)
{
New-Item -ItemType Directory -Force -Path $PSModulePath
}
#######################
# Checking to see if PowerCLI is installed in Program Files, takes 5-30 seconds
#######################
write-host "Checking if PowerCLI is installed in Program Files, wait 5-30 seconds"
$PowerCLIInstalled = Get-WmiObject -Class Win32_Product | Where-Object {$_.Name -eq "VMware vSphere PowerCLI"}
#######################
# If PowerCLI is installed then removing it, so we can run from the module instead
#######################
if ($PowerCLIInstalled -ne $null)
{
write-host "PowerCLI Installed - Uninstalling to allow for new PowerCLI module"
# Uninstalling PS module
$PowerCLIUninstall = $PowerCLIInstalled.Uninstall()
# Checking return value for success
$PowerCLIUninstallValue = $PowerCLIUninstall.ReturnValue
if ($PowerCLIUninstallValue -ne 0)
{
write-host "Uninstall Of PowerCLI Failed - Most likely due to not running as administrator"
}
# Finished uninstall
}
#######################
# Checking to see if the PowerCLI module is already installed
#######################
$PowerCLIModuleCheck = Get-Module -ListAvailable VMware.PowerCLI
#######################
# If PowerCLI module is not installed, nothing found, then running install...
#######################
if ($PowerCLIModuleCheck -eq $null)
{
write-host "PowerCLI Module Not Found - Installing"
# Not installed, finding module online
Find-Module -Name VMware.PowerCLI
# Trusting PS Gallery to remove prompt on install
Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
# Installing module
Install-Module -Name VMware.PowerCLI –Scope CurrentUser -Confirm:$false -AllowClobber
# If running this is a repeat demo/test, you can uninstall the module using the below:
# Uninstall-Module -Name VMware.PowerCLI -Confirm:$false
}
#######################
# Testing import of PowerCLI module
#######################
Import-Module VMware.PowerCLI
Try
{
$PowerCLICommandTest = Get-VICommand
$PowerCLIImportTest = $True
}
Catch
{
$PowerCLIImportTest = $False
}
#######################
# Outputting result
#######################
if ($PowerCLIImportTest -eq $True)
{
write-host "New PowerCLI Module Successfully Installed"
}
else
{
write-host "Something went wrong! Maybe you, maybe me. Does this computer have internet access and did you run as administrator?"
}
#######################
# End of script
#######################