# Instructions: Copy the certificate from your Rubrik connector installer to the dir below, or a dir/share of you choosing, rename it as you wish
# Configure the $RubrikProdCert and RubrikDRCert variables and then run the script to enable the host to connect to the Rubrik cluster cert specified
# Configure the $ProdIPRange to match your prod DC
#
# This script sets the Rubrik connector to the Rubrik cluster cert specified
#
# Configure the Rubrik cluster cert, can be a share, existing, or new directory
$RubrikPRODCert = "C:\ProgramData\Rubrik\Rubrik Backup Service\PROD.crt"
$RubrikDRCert = "C:\ProgramData\Rubrik\Rubrik Backup Service\DR.crt"
$ProdIPRange = "192.168.0"
###############################
# Nothing to configure below, running the script
###############################
$IPAddress = Get-NetIPConfiguration | Select -ExpandProperty IPv4Address -First 1 | Select -ExpandProperty IPAddress
# Matching IP location
IF ($IPAddress -match $ProdIPRange)
{
# Running in PROD
"Running in PROD
Updating to PROD Rubrik Cert"
$RubrikRegistryPath = "HKLM:\Software\Rubrik Inc.\Backup Service"
$RubrikRegistryKey = "Trusted Certificate Path"
# Updating registry key
New-ItemProperty -Path $RubrikRegistryPath -Name $RubrikRegistryKey -Value $RubrikPRODCert -PropertyType String -Force | Out-Null
# Restarting Rubrik backup service
Restart-Service "Rubrik Backup Service" -Force
}
ELSE
{
# Running in DR
"Running in DR
Updating to DR Rubrik Cert"
$RubrikRegistryPath = "HKLM:\Software\Rubrik Inc.\Backup Service"
$RubrikRegistryKey = "Trusted Certificate Path"
# Updating registry key
New-ItemProperty -Path $RubrikRegistryPath -Name $RubrikRegistryKey -Value $RubrikDRCert -PropertyType String -Force | Out-Null
# Restarting Rubrik backup service
Restart-Service "Rubrik Backup Service" -Force
}


