# Instructions: Copy the certificate from your Rubrik connector installer to the dir below, or a dir/share of you choosing, rename it as you wish
# Configure the $RubrikProdCert variable and then run the script to enable the host to connect to the Rubrik cluster cert specified
#
# This script sets the Rubrik connector to the Rubrik cluster cert specified
#
# Configure the Rubrik cluster cert, can be a share, existing, or new directory
$RubrikProdCert = "C:\ProgramData\Rubrik\Rubrik Backup Service\PROD.crt"
###############################
# Nothing to configure below, running the script
###############################
$RubrikRegistryPath = "HKLM:\Software\Rubrik Inc.\Backup Service"
$RubrikRegistryKey = "Trusted Certificate Path"
# Updating registry key
New-ItemProperty -Path $RubrikRegistryPath -Name $RubrikRegistryKey -Value $RubrikProdCert -PropertyType String -Force | Out-Null
# Restarting Rubrik backup service
Restart-Service "Rubrik Backup Service" -Force