########################################################################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
########################################################################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
################################################
# Description:
# This script shows you how to perform an on demand snapshot of all VMs in a SLA domain to the same or a different SLA
################################################ 
# Requirements:
# - PowerShell 5.1
# - Run PowerShell as administrator with command "Set-ExecutionPolcity unrestricted" on the host running the script
# - A Rubrik cluster or EDGE appliance, network access to it and credentials to login
# - A SQL database protected with an SLA domain
################################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever (including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss) arising out of the use of or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
################################################
# Configure the variables below for the Rubrik Cluster
################################################
$RubrikCluster = "192.168.1.201"
$SourceSLADomainName = "LegacyVMs"
$SnapSLADomainName = "LegacyVMs"
$ScriptDirectory = "C:\RubrikScripts\"
################################################################################################
# Running the script, nothing to change below
################################################################################################
###############################################
# Importing Rubrik credentials
###############################################
# Setting credential file
$RubrikCredentialsFile = $ScriptDirectory + "RubrikCredentials.xml"
# Testing if file exists
$RubrikCredentialsFileTest =  Test-Path $RubrikCredentialsFile
# IF doesn't exist, prompting and saving credentials
IF ($RubrikCredentialsFileTest -eq $False)
{
$RubrikCredentials = Get-Credential -Message "Enter Rubrik login credentials"
$RubrikCredentials | EXPORT-CLIXML $RubrikCredentialsFile -Force
}
# Importing credentials
$RubrikCredentials = IMPORT-CLIXML $RubrikCredentialsFile
###############################################
# Importing Rubrik module
###############################################
# Installing Rubrik module if not already installed
$RubrikModuleCheck = Get-Module -ListAvailable -Name Rubrik
IF ($RubrikModuleCheck -eq $null)
{
Install-Module -Name Rubrik -Scope CurrentUser -Confirm:$false
}
# Importing Rubrik Module
Import-Module Rubrik
# Connect to Rubrik using module
Connect-Rubrik -Server $RubrikCluster -Credential $RubrikCredentials
# Selecting VM IDs from VM List
$VMList = Get-RubrikVM
$VMNames = $VMList | Where-Object {$_.effectiveSlaDomainName -eq $SourceSLADomainName}  | Sort-Object name | Select -ExpandProperty name 
$VMIDs = $VMList | Where-Object {$_.effectiveSlaDomainName -eq $SourceSLADomainName} | Select -ExpandProperty id
# Output to host
"Performing On-Demand Snapshot For VMs:"
"----------------------"
$VMNames
"----------------------"
################################################
# Performing On Demand Snapshot ForEach VM
################################################
ForEach ($VMID in $VMIDs)
{
# POSTing request to Snapshot SQL DB
$RubrikJobRequest = New-RubrikSnapshot -id $VMID -SLA $SnapSLADomainName -Confirm:$false
}
################################################
# End of script
################################################