########################################################################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
########################################################################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
################################################
# Description:
# This script shows you how to start the backup of a SQL DB and check the status of the task using the Rubrik PowerShell module
################################################ 
# Requirements:
# - PowerShell 5.1
# - Run PowerShell as administrator with command "Set-ExecutionPolcity unrestricted" on the host running the script
# - A Rubrik cluster or EDGE appliance, network access to it and credentials to login
# - A SQL database protected with an SLA domain
################################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever (including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss) arising out of the use of or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
################################################
# Configure the variables below for the Rubrik Cluster
################################################
$RubrikCluster = "192.168.1.201"
$SQLDBName = "SQL16-VM10-DemoDB03"
$SLADomainName = "Tier1-Gold"
################################################
# Running the script, nothing to change below
################################################
# Prompting for Rubrik Username and password
$RubrikCreds = Get-Credential
# Installing Rubrik module if not already installed
$RubrikModuleCheck = Get-Module  -ListAvailable Rubrik
IF ($RubrikModuleCheck -eq $null)
{
Install-Module -Name Rubrik -Scope CurrentUser -Confirm:$false
}
# Importing Rubrik Module
Import-Module Rubrik
# Connect to Rubrik using module
Connect-Rubrik -Server $RubrikCluster -Credential $RubrikCreds
# Selecting DB ID
$SQLDBID = Get-RubrikDatabase | Where-Object {$_.name -eq $SQLDBName} | Select -ExpandProperty id
# POSTing request to Snapshot SQL DB
$SQLJobRequest = New-RubrikSnapshot -id $SQLDBID -SLA $SLADomainName -Confirm:$false
################################################
# Getting Job status on a loop
################################################
# Getting Status URL
$SQLJobStatusURL = $SQLJobRequest.links.href
# Setting counter
$SQLJobStatusCount = 0
DO
{
$SQLJobStatusCount ++
# Getting status
Try 
{
$SQLJobStatusResponse = Invoke-RestMethod -Uri $SQLJobStatusURL -Headers $Global:rubrikconnection.header
# Setting status
$SQLJobStatus = $SQLJobStatusResponse.status
}
Catch 
{
$_.Exception.ToString()
$Error[0] | Format-List -Force
$SQLJobStatus = "FAILED"
}
# Output to host
"SQLJobStatus: $SQLJobStatus"
# Waiting 15 seconds before trying again, but only if not succeeded
IF ($SQLJobStatus -ne "SUCCEEDED")
{
sleep 15
}
# Will run until it succeeds, fails, or hits 24 hours (5760 is number of seconds in a day / 15)
} Until (($SQLJobStatus -eq "SUCCEEDED") -OR ($SQLJobStatus -eq "FAILED") -OR ($SQLJobStatusCount -eq 5760))
################################################
# Perform any next actions you want here
################################################
IF ($SQLJobStatus -eq "SUCCEEDED")
{
# Put your next actions, if needed, here
}
################################################
# End of script
################################################