########################################################################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
########################################################################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
################################################
# Description:
# This script shows you how to start the on demand snapshot of a particular VM to the SLA domain you specify, it also checks the status of the task
################################################ 
# Requirements:
# - PowerShell 5.1
# - Run PowerShell as administrator with command "Set-ExecutionPolcity unrestricted" on the host running the script
# - A Rubrik cluster or EDGE appliance, network access to it and credentials to login
# - A SQL database protected with an SLA domain
################################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever (including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss) arising out of the use of or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
################################################
# Configure the variables below for the Rubrik Cluster
################################################
$RubrikCluster = "192.168.1.201"
$VMName = "DemoApp1-VM01"
$SLADomainName = "Tier1-Gold"
################################################
# Running the script, nothing to change below
################################################
# Prompting for Rubrik Username and password
$RubrikCreds = Get-Credential
# Installing Rubrik module if not already installed
$RubrikModuleCheck = Get-Module  -ListAvailable Rubrik
IF ($RubrikModuleCheck -eq $null)
{
Install-Module -Name Rubrik -Scope CurrentUser -Confirm:$false
}
# Importing Rubrik Module
Import-Module Rubrik
# Connect to Rubrik using module
Connect-Rubrik -Server $RubrikCluster -Credential $RubrikCreds
# Selecting VM ID from VM List
$VMList = Get-RubrikVM
$VMID = $VMList | Where-Object {$_.name -eq $VMName} | Select -ExpandProperty id
# POSTing request to Snapshot SQL DB
$RubrikJobRequest = New-RubrikSnapshot -id $VMID -SLA $SLADomainName -Confirm:$false
################################################
# Getting Job status on a loop
################################################
# Getting Status URL
$RubrikJobStatusURL = $RubrikJobRequest.links.href
# Setting counter
$RubrikJobStatusCount = 0
DO
{
$RubrikJobStatusCount ++
# Getting status
Try 
{
$RubrikJobStatusResponse = Invoke-RestMethod -Uri $RubrikJobStatusURL -Headers $Global:rubrikconnection.header
# Setting status
$RubrikJobStatus = $RubrikJobStatusResponse.status
}
Catch 
{
$_.Exception.ToString()
$Error[0] | Format-List -Force
$RubrikJobStatus = "FAILED"
}
# Output to host
"RubrikJobStatus: $RubrikJobStatus"
# Waiting 15 seconds before trying again, but only if not succeeded
IF ($RubrikJobStatus -ne "SUCCEEDED")
{
sleep 15
}
# Will run until it succeeds, fails, or hits 24 hours (5760 is number of seconds in a day / 15)
} Until (($RubrikJobStatus -eq "SUCCEEDED") -OR ($RubrikJobStatus -eq "FAILED") -OR ($RubrikJobStatusCount -eq 5760))
################################################
# Perform any next actions you want here
################################################
IF ($RubrikJobStatus -eq "SUCCEEDED")
{
# Put your next actions, if needed, here
}
################################################
# End of script
################################################