﻿#####################################################################
# Start of the script - Description, Requirements & Legal Disclaimer
#####################################################################
# Written by: Joshua Stenhouse joshuastenhouse@gmail.com
##############################################
# Description:
# This script is step 2 of 4 for creating a vSphere Change Management Database for free and it is responsible for inserting data from vSphere into the SQL database.
##############################################
# Requirements:
# - Internet access on the computer running this script to download the SqlServer and PowerCLI modules
# - Set-executionpolicy unrestricted on the computer running the script
# - Run the script as administrator to allow the install of the new module for all users
# - Access to a SQL server instance with sufficient permissions to insert into the database created
# - Access to a vCenter with permissions to read all the objects queried
##############################################
# Legal Disclaimer:
# This script is written by Joshua Stenhouse is not supported under any support program or service. 
# All scripts are provided AS IS without warranty of any kind. 
# The author further disclaims all implied warranties including, without limitation, any implied warranties of merchantability or of fitness for a particular purpose. 
# The entire risk arising out of the use or performance of the sample scripts and documentation remains with you. 
# In no event shall its authors, or anyone else involved in the creation, production, or delivery of the scripts be liable for any damages whatsoever. 
# Including, without limitation, damages for loss of business profits, business interruption, loss of business information, or other pecuniary loss arising out of the use of,
# or inability to use the sample scripts or documentation, even if the author has been advised of the possibility of such damages.
##############################################
# Configure the variables below for connecting to the SQL database & vCenter
##############################################
# vSphere server & authentication
$vCenterServer = "192.168.1.10"
$vCenterUsername = "administrator@lab.local"
$vCenterPassword = "Srt1234!"
# SQL server, database & authentication
$SQLInstance = ".\SQLEXPRESS"
$SQLDatabase = "vSphereChangeControlv1"
$SQLUsername = "sa"
$SQLPassword = "Srt1234!"
############################################################################################
# Nothing to change below this line, comments provided if you need/want to change anything
############################################################################################
#######################
# Checking to see if the PowerCLI module is already installed, if not installing it
#######################
$PowerCLIModuleCheck = Get-Module -ListAvailable VMware.PowerCLI
if ($PowerCLIModuleCheck -eq $null)
{
write-host "PowerCLI Module Not Found - Installing"
# Trusting PS Gallery to remove prompt on install
Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
# Installing module
Install-Module -Name VMware.PowerCLI –Scope AllUsers -Confirm:$false
}
#######################
# Importing the PowerCLI module
#######################
Import-Module VMware.PowerCLI
##############################################
# Checking to see if the SqlServer module is already installed, if not installing it
##############################################
$SQLModuleCheck = Get-Module -ListAvailable SqlServer
if ($SQLModuleCheck -eq $null)
{
write-host "SqlServer Module Not Found - Installing"
# Not installed, trusting PS Gallery to remove prompt on install
Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
# Installing module
Install-Module -Name SqlServer –Scope AllUsers -Confirm:$false -AllowClobber
}
##############################################
# Importing the SqlServer module
##############################################
Import-Module SqlServer
##############################################
# Connecting to vCenter
##############################################
Try 
{
connect-viserver -Server $vCenterServer -User $vCenterUsername -Password $vCenterPassword 
$vCenterAuthentication = "PASS"
}
Catch 
{
Write-Host $_.Exception.ToString()
$error[0] | Format-List -Force
$vCenterAuthentication = "FAIL"
}
##############################################
# Setting the current dates (for use in each SQL row inserted)
##############################################
$LastUpdated = "{0:yyyy-MM-dd HH:mm:ss}" -f (Get-Date)
##############################################
# Inserting into VMs SQL Table
##############################################
# Thanks to Alan Renouf for how to get toolsstatus @ https://blogs.vmware.com/PowerCLI/2011/11/vm-tools-and-virtual-hardware-versions.html
New-VIProperty -Name ToolsVersion -ObjectType VirtualMachine -ValueFromExtensionProperty 'Config.tools.ToolsVersion'  -Force 
New-VIProperty -Name ToolsVersionStatus -ObjectType VirtualMachine -ValueFromExtensionProperty 'Guest.ToolsVersionStatus' -Force
$VMs = Get-VM | Select *
$VMGuestInfo = Get-VM | Get-VMGuest | Select *
# Inserting each row
ForEach ($VM in $VMs)
{
$VMID = $VM.Id
$Name = $VM.Name
$PowerState = $VM.PowerState
$Notes = $VM.Notes
$Guest = $VM.Guest
$NumCpu = $VM.NumCpu -as [int]
$CoresPerSocket = $VM.CoresPerSocket -as [int]
$MemoryGB = $VM.MemoryGB -as [int]
$VMHostId = $VM.VMHostId
$VMHost = $VM.VMHost
$VApp = $VM.VApp
$FolderId = $VM.FolderId
$Folder = $VM.Folder
$ResourcePoolId = $VM.ResourcePoolId
$ResourcePool = $VM.ResourcePool
$HARestartPriority = $VM.HARestartPriority
$HAIsolationResponse = $VM.HAIsolationResponse
$DrsAutomationLevel = $VM.DrsAutomationLevel
$VMSwapfilePolicy = $VM.VMSwapfilePolicy
$VMResourceConfiguration = $VM.VMResourceConfiguration
$Version = $VM.Version
$UsedSpaceGB = $VM.UsedSpaceGB -as [int]
$ProvisionedSpaceGB = $VM.ProvisionedSpaceGB -as [int]
$DatastoreIdList = $VM.DatastoreIdList
$ExtensionData = $VM.ExtensionData
$CustomFields = $VM.CustomFields
$Uid = $VM.Uid
$PersistentId = $VM.PersistentId
$ToolsVersion = $VM.ToolsVersion
$ToolsVersionStatus = $VM.ToolsVersionStatus
# Pulling fields from VMGuestInfo to consolidate into a single table
$VMGuest = $VMGuestInfo | Where-Object {$_.Vmid -eq $VMID}
$OSFullName = $VMGuest.OSFullName
$IPAddress = $VMGuest.IPAddress
$State = $VMGuest.State
$Hostname = $VMGuest.HostName
$Nics = $VMGuest.Nics
$GuestId = $VMGuest.GuestId
$RuntimeGuestId = $VMGuest.RuntimeGuestId
$GuestFamily = $VMGuest.GuestFamily
# Diagnostic output
# write-host "SQL Insert for VM:$Name"
# Creating SQL INSERT
$SQLVMInsert = "USE $SQLDatabase
INSERT INTO VMs (LastUpdated, VMID, Name, PowerState, Notes, Guest, NumCpu, CoresPerSocket, MemoryGB, VMHostId, VMHost, VApp, FolderId, 
Folder, ResourcePoolId, ResourcePool, HARestartPriority, HAIsolationResponse, DrsAutomationLevel, VMSwapfilePolicy, VMResourceConfiguration, 
Version, UsedSpaceGB, ProvisionedSpaceGB, DatastoreIdList, ExtensionData, CustomFields, Uid, PersistentId, OSFullName, 
IPAddress, State, Hostname, Nics, GuestID, RuntimeGuestId, ToolsVersion, ToolsVersionStatus, GuestFamily)
VALUES('$LastUpdated', '$VMID', '$Name', '$PowerState', '$Notes', '$Guest', '$NumCpu', '$CoresPerSocket', '$MemoryGB', '$VMHostId', '$VMHost', '$VApp', '$FolderId', 
'$Folder', '$ResourcePoolId', '$ResourcePool', '$HARestartPriority', '$HAIsolationResponse', '$DrsAutomationLevel', '$VMSwapfilePolicy', '$VMResourceConfiguration', 
'$Version', '$UsedSpaceGB', '$ProvisionedSpaceGB', '$DatastoreIdList', '$ExtensionData', '$CustomFields', '$Uid', '$PersistentId', '$OSFullName', 
'$IPAddress', '$State', '$Hostname', '$Nics', '$GuestId', '$RuntimeGuestId', '$ToolsVersion', '$ToolsVersionStatus', '$GuestFamily');"
# Running the INSERT query
invoke-sqlcmd -query $SQLVMInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# End of per VM action below
}
# End of per VM action above
##############################################
# Inserting into VMDisks SQL Table
##############################################
$VMHardDisks = Get-VM | Get-HardDisk | Select *
# Inserting each row
ForEach ($VMHardDisk in $VMHardDisks)
{
$VMID = $VMHardDisk.ParentId
$Parent = $VMHardDisk.Parent
$DiskID = $VMHardDisk.Id
$Name = $VMHardDisk.Name
$Filename = $VMHardDisk.Filename
$CapacityGB = $VMHardDisk.CapacityGB -as [int]
$Persistence = $VMHardDisk.Persistence
$DiskType = $VMHardDisk.DiskType
$StorageFormat = $VMHardDisk.StorageFormat
# Creating SQL INSERT
$SQLDiskInsert = "USE $SQLDatabase
INSERT INTO VMDisks (LastUpdated, VMID, Parent, DiskID, Name, Filename, CapacityGB, Persistence, DiskType, StorageFormat)
VALUES('$LastUpdated', '$VMID', '$Parent', '$DiskID', '$Name', '$Filename', '$CapacityGB', '$Persistence', '$DiskType', '$StorageFormat');"
# Running the INSERT query
invoke-sqlcmd -query $SQLDiskInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
##############################################
# Inserting into VMDiskUsage SQL Table
##############################################
# Thanks to Alan Renouf for the example script which I used as a base: http://www.virtu-al.net/2010/01/27/powercli-virtual-machine-disk-usage/
$AllVMsView = Get-View -ViewType VirtualMachine | Where {-not $_.Config.Template}
$VMGuestDiskInfo = $AllVMsView | Select *, @{N="NumDisks";E={@($_.Guest.Disk.Length)}} | Sort-Object -Descending NumDisks
# Populating the array
ForEach ($VM in $VMGuestDiskInfo){
# Starting disk number at 0 for each VM
 $DiskNum = 0
 Foreach ($Disk in $VM.Guest.Disk){
    $VMID = $VM.MoRef
    $Name = $VM.name
    $DiskNum = $DiskNum -as [INT]
    $DiskPath = $Disk.DiskPath
    $DiskCapacityGB = ([math]::Round($disk.Capacity/ 1GB)) -as [INT]
    $DiskFreeSpaceGB = ([math]::Round($disk.FreeSpace / 1GB)) -as [INT]
    $DiskCapacityMB = ([math]::Round($disk.Capacity/ 1MB)) -as [INT]
    $DiskFreeSpaceMB = ([math]::Round($disk.FreeSpace / 1MB)) -as [INT]
# Creating SQL INSERT
$SQLVMGuestDiskInsert = "USE $SQLDatabase
INSERT INTO VMDiskUsage (LastUpdated, VMID, Name, DiskNum, DiskPath, DiskCapacityGB, DiskFreeSpaceGB, DiskCapacityMB, DiskFreeSpaceMB)
VALUES('$LastUpdated', '$VMID', '$Name', '$DiskNum', '$DiskPath', '$DiskCapacityGB', '$DiskFreeSpaceGB', '$DiskCapacityMB', '$DiskFreeSpaceMB');"
# Running the INSERT query
invoke-sqlcmd -query $SQLVMGuestDiskInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
# Incrementing disk number
$DiskNum++
 } 
}
##############################################
# Inserting into VMNICs SQL Table
##############################################
$VMNetworkAdapters = Get-VM | Get-NetworkAdapter | Select *
# Inserting each row
ForEach ($VMNetworkAdapter in $VMNetworkAdapters)
{
$VMID = $VMNetworkAdapter.ParentId
$Parent = $VMNetworkAdapter.Parent
$NICID = $VMNetworkAdapter.Id
$Name = $VMNetworkAdapter.Name
$MacAddress = $VMNetworkAdapter.MacAddress
$NetworkName = $VMNetworkAdapter.NetworkName
$ConnectionState = $VMNetworkAdapter.ConnectionState
$WakeOnLanEnabled = $VMNetworkAdapter.WakeOnLanEnabled
$Type = $VMNetworkAdapter.Type
# Creating SQL INSERT
$SQLNICInsert = "USE $SQLDatabase
INSERT INTO VMNICs (LastUpdated, VMID, Parent, NICID, Name, MacAddress, NetworkName, ConnectionState, WakeOnLanEnabled, Type)
VALUES('$LastUpdated', '$VMID', '$Parent', '$NICID', '$Name', '$MacAddress', '$NetworkName', '$ConnectionState', '$WakeOnLanEnabled', '$Type');"
# Running the INSERT query
invoke-sqlcmd -query $SQLNICInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
##############################################
# Inserting into Datastores SQL Table
##############################################
$Datastores = Get-Datastore | Select *
# Inserting each row
ForEach ($Datastore in $Datastores)
{
$DatastoreID = $Datastore.Id
$Name = $Datastore.Name
$CapacityGB = $Datastore.CapacityGB -as [int]
$FreeSpaceGB = $Datastore.FreeSpaceGB -as [int]
$State = $Datastore.State
$Type = $Datastore.Type
$FileSystemVersion = $Datastore.FileSystemVersion -as [int]
$Accessible = $Datastore.Accessible
$StorageIOControlEnabled = $Datastore.StorageIOControlEnabled
$CongestionThresholdMillisecond = $Datastore.CongestionThresholdMillisecond -as [int]
$ParentFolderId = $Datastore.ParentFolderId
$ParentFolder = $Datastore.ParentFolder
$DatacenterId = $Datastore.DatacenterId
$Datacenter = $Datastore.Datacenter
$Uid = $Datastore.Uid
# Creating SQL INSERT
$SQLDatastoreInsert = "USE $SQLDatabase
INSERT INTO Datastores (LastUpdated, DatastoreID, Name, CapacityGB, FreeSpaceGB, State, Type, FileSystemVersion, Accessible, 
StorageIOControlEnabled, CongestionThresholdMillisecond, ParentFolderId, ParentFolder, DatacenterId, Datacenter, Uid)
VALUES('$LastUpdated', '$DatastoreID', '$Name', '$CapacityGB', '$FreeSpaceGB', '$State', '$Type', '$FileSystemVersion', '$Accessible', 
'$StorageIOControlEnabled', '$CongestionThresholdMillisecond', '$ParentFolderId', '$ParentFolder', '$DatacenterId', '$Datacenter', '$Uid');"
# Running the INSERT query
invoke-sqlcmd -query $SQLDatastoreInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
##############################################
# Inserting into PortGroups SQL Table
##############################################
$VirtualPortGroups = Get-VirtualPortGroup | Select *
# Inserting each row
ForEach ($VirtualPortGroup in $VirtualPortGroups)
{
$VirtualSwitchId = $VirtualPortGroup.VirtualSwitchId
$Name = $VirtualPortGroup.Name
$VirtualSwitch = $VirtualPortGroup.VirtualSwitch
$VirtualSwitchName = $VirtualPortGroup.VirtualSwitchName
$PortGroupKey = $VirtualPortGroup.Key
$VLanId = $VirtualPortGroup.VLanId -as [int]
$VMHostId = $VirtualPortGroup.VMHostId
$VMHostUid = $VirtualPortGroup.VMHostUid
$Uid = $VirtualPortGroup.Uid
# Creating SQL INSERT
$SQLPortGroupInsert = "USE $SQLDatabase
INSERT INTO PortGroups (LastUpdated, VirtualSwitchId, Name, VirtualSwitch, VirtualSwitchName, PortGroupKey, VLanId, VMHostId, VMHostUid, Uid)
VALUES('$LastUpdated', '$VirtualSwitchId', '$Name', '$VirtualSwitch', 'VirtualSwitchName', '$PortGroupKey', '$VLanId', '$VMHostId', '$VMHostUid', '$Uid');"
# Running the INSERT query
invoke-sqlcmd -query $SQLPortGroupInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
##############################################
# Inserting into Hosts SQL Table 
##############################################
$Hosts = Get-VMHost | Select Id,Name,State,ConnectionState,PowerState,NumCpu,CpuTotalMhz,CpuUsageMhz,MemoryTotalGB,MemoryUsageGB,ProcessorType,HyperthreadingActive,TimeZone,Version,Build
ForEach ($ESXiHost in $Hosts)
{
$HostID = $ESXiHost.Id
$Name = $ESXiHost.Name
$State = $ESXiHost.State
$ConnectionState = $ESXiHost.ConnectionState
$PowerState = $ESXiHost.PowerState
$NumCpu = $ESXiHost.NumCpu -as [int]
$CpuTotalMhz = $ESXiHost.CpuTotalMhz -as [int]
$CpuUsageMhz = $ESXiHost.CpuUsageMhz -as [int]
$MemoryTotalGB = $ESXiHost.MemoryTotalGB -as [int]
$MemoryUsageGB = $ESXiHost.MemoryUsageGB -as [int]
$ProcessorType = $ESXiHost.ProcessorType
$HyperthreadingActive = $ESXiHost.HyperthreadingActive
$TimeZone = $ESXiHost.TimeZone
$Version = $ESXiHost.Version -as [int]
$Build = $ESXiHost.Build -as [int]
$Parent = $ESXiHost.Parent
$IsStandalone = $ESXiHost.IsStandalone
$VMSwapfileDatastore = $ESXiHost.VMSwapfileDatastore
$StorageInfo = $ESXiHost.StorageInfo
$NetworkInfo = $ESXiHost.NetworkInfo -as [int]
$DiagnosticPartition = $ESXiHost.DiagnosticPartition
$FirewallDefaultPolicy = $ESXiHost.FirewallDefaultPolicy
$ApiVersion = $ESXiHost.ApiVersion -as [int]
$MaxEVCMode = $ESXiHost.MaxEVCMode
$Manufacturer = $ESXiHost.Manufacturer
$Model = $ESXiHost.Model
$DatastoreIdList = $ESXiHost.DatastoreIdList
$Uid = $ESXiHost.Uid
# Creating SQL INSERT
$SQLHostInsert = "USE $SQLDatabase
INSERT INTO Hosts (LastUpdated, HostID, Name, State, ConnectionState, PowerState, NumCpu, CpuTotalMhz, CpuUsageMhz, MemoryTotalGB, 
MemoryUsageGB, ProcessorType, HyperthreadingActive, TimeZone, Version, Build, Parent, IsStandalone, VMSwapfileDatastore, StorageInfo, NetworkInfo, 
DiagnosticPartition, FirewallDefaultPolicy, ApiVersion, MaxEVCMode, Manufacturer, Model, DatastoreIdList, Uid)
VALUES('$LastUpdated', '$HostID', '$Name', '$State', '$ConnectionState', '$PowerState', '$NumCpu', '$CpuTotalMhz', '$CpuUsageMhz', '$MemoryTotalGB', 
'$MemoryUsageGB', '$ProcessorType', '$HyperthreadingActive', '$TimeZone', '$Version', '$Build', '$Parent', '$IsStandalone', '$VMSwapfileDatastore', '$StorageInfo', '$NetworkInfo',
'$DiagnosticPartition', '$FirewallDefaultPolicy', '$ApiVersion', '$MaxEVCMode', '$Manufacturer', '$Model', '$DatastoreIdList', '$Uid');"
# Running the INSERT query
invoke-sqlcmd -query $SQLHostInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
##############################################
# Inserting into Clusters SQL Table 
##############################################
$Clusters = Get-Cluster | Select *
# Inserting each row
ForEach ($Cluster in $Clusters)
{
$ClusterID = $Cluster.Id
$Name = $Cluster.Name
$DrsEnabled = $Cluster.DrsEnabled
$DrsMode = $Cluster.DrsMode
$DrsAutomationLevel = $Cluster.DrsAutomationLevel
$HAEnabled = $Cluster.HAEnabled
$HAAdmissionControlEnabled = $Cluster.HAAdmissionControlEnabled
$HAFailoverLevel = $Cluster.HAFailoverLevel
$HARestartPriority = $Cluster.HARestartPriority
$HAIsolationResponse = $Cluster.HAIsolationResponse
$HATotalSlots = $Cluster.HATotalSlots
$HAUsedSlots = $Cluster.HAUsedSlots
$HAAvailableSlots = $Cluster.HAAvailableSlots
$HASlotCpuMHz = $Cluster.HASlotCpuMHz
$HASlotMemoryGB = $Cluster.HASlotMemoryGB
$HASlotNumVCpus = $Cluster.HASlotNumVCpus
$ParentId = $Cluster.ParentId
$ParentFolder = $Cluster.ParentFolder
$VMSwapfilePolicy = $Cluster.VMSwapfilePolicy
$VsanEnabled = $Cluster.VsanEnabled
$VsanDiskClaimMode = $Cluster.VsanDiskClaimMode
$EVCMode = $Cluster.EVCMode
$CustomFields = $Cluster.CustomFields
$Uid = $Cluster.Uid
# Creating SQL INSERT
$SQLClusterInsert = "USE $SQLDatabase
INSERT INTO Clusters (LastUpdated, ClusterID, Name, DrsEnabled, DrsMode, DrsAutomationLevel, HAEnabled, HAAdmissionControlEnabled, HAFailoverLevel, HARestartPriority, 
HAIsolationResponse, HATotalSlots, HAUsedSlots, HAAvailableSlots, HASlotCpuMHz, HASlotMemoryGB, HASlotNumVCpus, ParentId, ParentFolder, VMSwapfilePolicy, 
VsanEnabled, VsanDiskClaimMode, EVCMode, CustomFields, Uid)
VALUES('$LastUpdated', '$ClusterID', '$Name', '$DrsEnabled', '$DrsMode', '$DrsAutomationLevel', '$HAEnabled', '$HAAdmissionControlEnabled', '$HAFailoverLevel', '$HARestartPriority', 
'$HAIsolationResponse', '$HATotalSlots', '$HAUsedSlots', '$HAAvailableSlots', '$HASlotCpuMHz', '$HASlotMemoryGB', '$HASlotNumVCpus', '$ParentId', '$ParentFolder', '$VMSwapfilePolicy',  
'$VsanEnabled', '$VsanDiskClaimMode', '$EVCMode', '$CustomFields', '$Uid');"
# Running the INSERT query
invoke-sqlcmd -query $SQLClusterInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
##############################################
# Inserting into Datacenters SQL Table 
##############################################
$Datacenters = Get-Datacenter | Select *
# Inserting each row
ForEach ($Datacenter in $Datacenters)
{
$DatacenterID = $Datacenter.Id
$Name = $Datacenter.Name
$CustomFields = $Datacenter.CustomFields
$ParentFolderId = $Datacenter.ParentFolderId
$ParentFolder = $Datacenter.ParentFolder
$Uid = $Datacenter.Uid
$DatastoreFolderId = $Datacenter.DatastoreFolderId
# Getting totals for the datacenter (makes this table useful)
$DCClusterCount = Get-Datacenter -Name $Name | Get-Cluster
$DCClusters = $DCClusterCount.Count
$DCHostCount = Get-Datacenter -Name $Name | Get-VMHost
$DCHosts = $DCHostCount.Count
$DCDatastoreCount = Get-Datacenter -Name $Name | Get-Datastore
$DCDatastores = $DCDatastoreCount.Count
$DCPortGroupCount = Get-Datacenter -Name $Name | Get-VirtualPortGroup
$DCPortGroups = $DCHostCount.Count
$DCVMCount = Get-Datacenter -Name $Name | Get-VM
$DCVMs = $DCVMCount.Count
$DCVMDiskCount = Get-Datacenter -Name $Name | Get-VM | Get-HardDisk
$DCVMDisks = $DCVMDiskCount.Count
$DCVMNICCount = Get-Datacenter -Name $Name | Get-VM | Get-NetworkAdapter
$DCVMNICs = $DCVMNICCount.Count
# Creating SQL INSERT
$SQLDatacenterInsert = "USE $SQLDatabase
INSERT INTO Datacenters (LastUpdated, DatacenterID, Name, Clusters, Hosts, Datastores, PortGroups, VMs, VMDisks, VMNICs, CustomFields, ParentFolderId, ParentFolder, Uid, DatastoreFolderId)
VALUES('$LastUpdated', '$DatacenterID', '$Name', '$DCClusters', '$DCHosts', '$DCDatastores', '$DCPortGroups', '$DCVMs', '$DCVMDisks', '$DCVMNICs', '$CustomFields', '$ParentFolderId', '$ParentFolder', '$Uid', '$DatastoreFolderId');"
# Running the INSERT query
invoke-sqlcmd -query $SQLDatacenterInsert -ServerInstance $SQLInstance -Username $SQLUsername -Password $SQLPassword
}
#######################
# Disconnecting from the vCenter
#######################
Disconnect-VIServer -Force -Confirm:$false
#######################
# End of script
#######################